import { useState } from "react";

export default function DanielAnders() {
  const [start, setStart] = useState<string>("2025-08-21T10:30");
  const [end, setEnd] = useState<string>("2025-08-21T13:30");

  // Calculate duration in hours
  const duration =
    (new Date(end).getTime() - new Date(start).getTime()) / (1000 * 60 * 60);

  // Example: 1h = 43 points
  const points = duration > 0 ? Math.round(duration * 43) : 0;

  const handleBooking = () => {
    alert(
      `Booking confirmed!\nStart: ${start}\nEnd: ${end}\nDuration: ${duration}h\nPoints: ${points}`
    );
  };

  return (
    <div className="min-h-screen bg-white text-black font-sans p-6 md:p-12">
      {/* Header */}
      <h1 className="text-4xl font-bold">DANIEL ANDERS</h1>
      <div className="flex gap-2 mt-2">
        <span className="px-3 py-1 rounded-full border text-sm">
          Bali, Indonesia
        </span>
        <span className="px-3 py-1 rounded-full border text-sm">
          Audio Engineer
        </span>
      </div>

      {/* Main Layout */}
      <div className="grid md:grid-cols-2 gap-8 mt-8">
        {/* Left Section */}
        <div>
          <img
            src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQOeZjZWEr4oFmJhILQQgTy7-WUX9BmRrAAFw&s" // <-- place image in /public/static/profile.jpg
            alt="Daniel Anders"
            className="rounded-xl shadow-lg w-full h-auto"
          />

          <section className="mt-8">
            <h2 className="text-xl font-bold mb-2">ABOUT</h2>
            <p className="text-gray-700 leading-relaxed">
              Bali is a city of innovation, culture, and creativity, and Nomadic
              Studios is proud to be at the heart of it. Our space here is
              designed to empower creators across disciplines, providing the
              tools, resources, and inspiration needed to take your work to the
              next level. Whether you're a local professional looking for a
              versatile studio or a traveling creator seeking a place to call
              your creative home, you'll find everything you need here.
            </p>
          </section>

          <section className="mt-6">
            <h2 className="text-xl font-bold mb-2">LANGUAGE SPOKEN</h2>
            <p className="text-gray-700">English</p>
          </section>
        </div>

        {/* Right Section (Booking Widget) */}
        <div className="border rounded-xl p-6 shadow-md h-fit flex flex-col gap-4">
          <div>
            <label className="block text-sm font-medium">Start</label>
            <input
              type="datetime-local"
              value={start}
              onChange={(e) => setStart(e.target.value)}
              className="w-full border rounded-md p-2 mt-1"
            />
          </div>

          <div>
            <label className="block text-sm font-medium">End</label>
            <input
              type="datetime-local"
              value={end}
              onChange={(e) => setEnd(e.target.value)}
              className="w-full border rounded-md p-2 mt-1"
            />
          </div>

          <p className="text-sm text-gray-600">
            Your reservation:{" "}
            {duration > 0 ? `${duration}h • From: ${points} points` : "Invalid"}
          </p>

          <button
            onClick={handleBooking}
            className="bg-black text-white py-3 rounded-md hover:bg-gray-800 transition"
          >
            BOOK NOW →
          </button>
        </div>
      </div>
    </div>
  );
}
